#FreeImageDLL=1
Structure FreeImageIO
  read_proc.l
  write_proc.l
  seek_proc.l
  tell_proc.l
EndStructure
#FIF_UNKNOWN = -1
#FIF_BMP     =  0
#FIF_ICO     =  1
#FIF_JPEG    =  2
#FIF_JNG     =  3
#FIF_KOALA   =  4
#FIF_LBM     =  5
#FIF_MNG     =  6
#FIF_PBM     =  7
#FIF_PBMRAW  =  8
#FIF_PCD     =  9
#FIF_PCX     = 10
#FIF_PGM     = 11
#FIF_PGMRAW  = 12
#FIF_PNG     = 13
#FIF_PPM     = 14
#FIF_PPMRAW  = 15
#FIF_RAS     = 16
#FIF_TARGA   = 17
#FIF_TIFF    = 18
#FIF_WBMP    = 19
#FIF_PSD     = 20
#FIF_CUT     = 21
#FIF_IFF = #FIF_LBM
#FIC_MINISWHITE = 0
#FIC_MINISBLACK = 1
#FIC_RGB        = 2
#FIC_PALETTE    = 3
#FIC_RGBALPHA   = 4
#FIQ_WUQUANT    = 0
#FIQ_NNQUANT    = 1
#TRUE           = 1
#FALSE          = 0
#BMP_DEFAULT         = 0
#CUT_DEFAULT         = 0
#ICO_DEFAULT         = 0
#ICO_FIRST           = 0
#ICO_SECOND          = 0
#ICO_THIRD           = 0
#IFF_DEFAULT         = 0
#JPEG_DEFAULT        = 0
#JPEG_FAST           = 1
#JPEG_ACCURATE       = 2
#JPEG_QUALITYSUPERB  = $80
#JPEG_QUALITYGOOD    = $100
#JPEG_QUALITYNORMAL  = $200
#JPEG_QUALITYAVERAGE = $400
#JPEG_QUALITYBAD     = $800
#KOALA_DEFAULT       = 0
#LBM_DEFAULT         = 0
#MNG_DEFAULT         = 0
#PCD_DEFAULT         = 0
#PCD_BASE            = 1
#PCD_BASEDIV4        = 2
#PCD_BASEDIV16       = 3
#PCX_DEFAULT         = 0
#PNG_DEFAULT         = 0
#PNG_IGNOREGAMMA     = 1
#PNM_DEFAULT         = 0
#PNM_SAVE_RAW        = 0
#PNM_SAVE_ASCII      = 1
#RAS_DEFAULT         = 0
#TARGA_DEFAULT       = 0
#TARGA_LOAD_RGB888   = 1
#TARGA_LOAD_RGB555   = 2
#TIFF_DEFAULT        = 0
#WBMP_DEFAULT        = 0
#PSD_DEFAULT         = 0
#MAX_PATH     = 260
#BI_RGB       = 0
#BI_RLE8      = 1
#BI_RLE4      = 2
#BI_BITFIELDS = 3

Procedure FreeImage_Init(LoadLocalPluginsOnly)
  OpenLibrary(#FreeImageDLL,"FreeImage.DLL")
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_Initialise@4",LoadLocalPluginsOnly)
EndProcedure
Procedure FreeImage_DeInit()
  Result=CallFunction(#FreeImageDLL,"_FreeImage_DeInitialise@0")
  CloseLibrary(#FreeImageDLL)
  ProcedureReturn result
EndProcedure
Procedure.s FreeImage_GetVersion()
  ProcedureReturn PeekS(CallFunction(#FreeImageDLL,"_FreeImage_GetVersion@0"))
EndProcedure
Procedure.s FreeImage_GetCopyrightMessage()
  ProcedureReturn PeekS(CallFunction(#FreeImageDLL,"_FreeImage_GetCopyrightMessage@0"))
EndProcedure
Procedure FreeImage_Allocate(Width,Height,BitsPerPixel,Red_Mask,Green_Mask,Blue_Mask)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_Allocate@24",Width,Height,BitsPerPixel,Red_Mask,Green_Mask,Blue_Mask)
EndProcedure
Procedure FreeImage_Free(dib)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_Free@4",DIB)
EndProcedure
Procedure FreeImage_GetFIFCount()
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_GetFIFCount@0")
EndProcedure
Procedure FreeImage_GetFIFFromFormat(Format$)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_GetFIFFromFormat@4",@Format$)
EndProcedure
Procedure FreeImage_GetFIFFromMime(Mime$)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_GetFIFFromMime@4",@Mime$)
EndProcedure
Procedure.s FreeImage_GetFormatFromFIF(ImageFormat)
  ProcedureReturn PeekS(CallFunction(#FreeImageDLL,"_FreeImage_GetFormatFromFIF@4",ImageFormat))
EndProcedure
Procedure.s FreeImage_GetFIFExtensionList(ImageFormat)
  ProcedureReturn PeekS(CallFunction(#FreeImageDLL,"_FreeImage_GetFIFExtensionList@4",ImageFormat))
EndProcedure
Procedure.s FreeImage_GetFIFDescription(ImageFormat)
  ProcedureReturn PeekS(CallFunction(#FreeImageDLL,"_FreeImage_GetFIFDescription@4",ImageFormat))
EndProcedure
Procedure.s FreeImage_GetFIFRegExpr(ImageFormat)
  ProcedureReturn PeekS(CallFunction(#FreeImageDLL,"_FreeImage_GetFIFDescription@4",ImageFormat))
EndProcedure
Procedure FreeImage_GetFIFFromFilename(Filename$)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_GetFIFFromFilename@4",@FileName$)
EndProcedure
Procedure FreeImage_FIFSupportsReading(ImageFormat)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_FIFSupportsReading@4",ImageFormat)
EndProcedure
Procedure FreeImage_FIFSupportsWriting(ImageFormat)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_FIFSupportsWriting@4",ImageFormat)
EndProcedure
Procedure FreeImage_FIFSupportsExportBPP(ImageFormat,BitsPerPixel)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_FIFSupportsExportBPP@8",ImageFormat,BitsPerPixel)
EndProcedure
Procedure FreeImage_Load(ImageFormat,FileName$,Flags)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_Load@12",ImageFormat,@FileName$,Flags)
EndProcedure
Procedure FreeImage_LoadFromHandle(ImageFormat,*IO_Callback_Functions.FreeImageIO,handle,Flags)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_LoadFromHandle@16",ImageFormat,*IO_Callback_Functions.FreeImageIO,handle,Flags)
EndProcedure
Procedure FreeImage_Save(ImageFormat,DIB,FileName$,Flags)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_Save@16",ImageFormat,DIB,@FileName$,Flags)
EndProcedure
Procedure FreeImage_GetFileType(FileName$)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_GetFileType@8",@FileName$,16)
EndProcedure
Procedure FreeImage_GetFileTypeFromHandle(*IO_Callback_Functions.FreeImageIO,Handle)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_GetFileTypeFromHandle@12",*IO_Callback_Functions.FreeImageIO,Handle,16)
EndProcedure
Procedure FreeImage_GetColorsUsed(dib)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_GetColorsUsed@4",dib)
EndProcedure
Procedure FreeImage_GetBits(dib)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_GetBits@4",dib)
EndProcedure
Procedure FreeImage_GetBPP(dib)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_GetBPP@4",dib)
EndProcedure
Procedure FreeImage_GetWidth(dib)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_GetWidth@4",dib)
EndProcedure
Procedure FreeImage_GetHeight(dib)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_GetHeight@4",dib)
EndProcedure
Procedure FreeImage_GetPalette(dib)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_GetPalette@4",dib)
EndProcedure
Procedure FreeImage_GetInfoHeader(dib)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_GetInfoHeader@4",dib)
EndProcedure
Procedure FreeImage_GetInfo(dib)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_GetInfo@4",dib)
EndProcedure
Procedure FreeImage_GetColorType(dib)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_GetColorType@4",dib)
EndProcedure
Procedure FreeImage_ConvertTo8Bits(dib)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_ConvertTo8Bits@4",dib)
EndProcedure
Procedure FreeImage_ConvertTo16Bits555(dib)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_ConvertTo16Bits555@4",dib)
EndProcedure
Procedure FreeImage_ConvertTo16Bits565(dib)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_ConvertTo16Bits565@4",dib)
EndProcedure
Procedure FreeImage_ConvertTo24Bits(dib)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_ConvertTo24Bits@4",dib)
EndProcedure
Procedure FreeImage_ConvertTo32Bits(dib)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_ConvertTo32Bits@4",dib)
EndProcedure
Procedure FreeImage_ColorQuantize(DIB,Quantize)
  ProcedureReturn CallFunction(#FreeImageDLL,"_FreeImage_ColorQuantize@8",DIB,Quantize)
EndProcedure
Procedure FreeImage_DIB_To_BITMAP(Dib)
  result=0
  If DIB=0 : ProcedureReturn 0 : EndIf
  lpBMIH = FreeImage_GetInfoHeader(DIB)
  If lpBMIH=0 : ProcedureReturn 0 : EndIf
  lpBMI = FreeImage_GetInfo(DIB)
  If lpbmi=0 : ProcedureReturn 0 : EndIf
  lpBits = FreeImage_GetBits(DIB)
  If LpBits=0 : ProcedureReturn 0 : EndIf
  hDC_Screen = GetDC_(GetDesktopWindow_())
  If hDC_Screen=0 : ProcedureReturn 0 : EndIf
  result = CreateDIBitmap_(hDC_Screen, lpBMIH, #CBM_INIT,lpBits,lpBMI,#DIB_RGB_COLORS)
  ReleaseDC_(GetDesktopWindow_(), hDC_Screen)
  ProcedureReturn result
EndProcedure
Procedure FreeImage_Bitmap_To_DIB(hBitmap)
  BmpInfo.BITMAP
  If hBITMAP=0 : ProcedureReturn 0 : EndIf
  If GetObject_(hBITMAP, 4+4+4+4+2+2+4, BmpInfo)=0 : ProcedureReturn 0 : EndIf
  TheWidth = BmpInfo\bmWidth
  TheHeight = BmpInfo\bmHeight
  TheBPP = 32
  hDC_Screen = GetDC_(GetDesktopWindow_())
  If hDC_Screen=0 : ProcedureReturn 0 : EndIf
  TempDIB = FreeImage_Allocate(TheWidth, TheHeight, TheBPP,0,0,0)
  If TempDIB=0 : ReleaseDC_(GetDesktopWindow_(),hDC_Screen):ProcedureReturn 0:EndIf
  lpBMI = FreeImage_GetInfo(TempDIB)
  If lpBMI=0 : FreeImage_Free(TempDib):ReleaseDC_(GetDesktopWindow_(),hDC_Screen):ProcedureReturn 0:EndIf
  lpBits = FreeImage_GetBits(TempDIB)
  If lpBits=0 : FreeImage_Free(TempDib):ReleaseDC_(GetDesktopWindow_(),hDC_Screen):ProcedureReturn 0:EndIf
  If GetDIBits_(hDC_Screen, hBITMAP, 0, TheHeight,lpBits,lpBMI,#DIB_RGB_COLORS)
    ReleaseDC_(GetDesktopWindow_(),hDC_Screen)
    ProcedureReturn TempDIB
  Else
    FreeImage_Free(TempDIB)
    ReleaseDC_(GetDesktopWindow_(),hDC_Screen)
    ProcedureReturn 0
  EndIf
EndProcedure
Procedure FreeImage_GetBitmapWidth(hBITMAP)
  bmpinfo.bitmap
  If hBITMAP = 0 : ProcedureReturn 0 : EndIf
  If GetObjectType_(hBITMAP) <> #OBJ_BITMAP : ProcedureReturn 0 : EndIf
  If GetObject_(hBITMAP, 4+4+4+4+2+2+4, BmpInfo) = 0 : ProcedureReturn 0 : EndIf
  ProcedureReturn BmpInfo\bmWidth
EndProcedure
Procedure FreeImage_GetBitmapHeight(hBITMAP)
  BmpInfo.BITMAP
  If hBITMAP = 0 : ProcedureReturn 0 : EndIf
  If GetObjectType_(hBITMAP) <> #OBJ_BITMAP : ProcedureReturn 0 : EndIf
  If GetObject_(hBITMAP, 4+4+4+4+2+2+4, BmpInfo) = 0 : ProcedureReturn 0 : EndIf
  ProcedureReturn BmpInfo\bmHeight
EndProcedure
Global FI_AdrMEM.l
Global FI_IOMEM.FreeImageIO
Procedure FI_ReadMEM(buffer,size,count,handle)
 For c=0 To count-1
   For s=0 To size-1
     PokeB(buffer+s,PeekB(FI_AdrMEM+s))
   Next
   FI_AdrMEM + size
   buffer + size
 Next
 ProcedureReturn count
EndProcedure
Procedure FI_WriteMEM(buffer,size,count,handle)
  ProcedureReturn size
EndProcedure
Procedure FI_SeekMEM(handle,offset,origin)
 If origin = #SEEK_SET
  FI_AdrMEM = handle + offset
 Else
  FI_AdrMEM + offset
 EndIf
 ProcedureReturn 0
EndProcedure
Procedure FI_TellMEM(handle)
 ProcedureReturn (FI_AdrMEM - handle)
EndProcedure
 FI_IOMEM\read_proc  = @FI_ReadMEM()
 FI_IOMEM\write_proc = @FI_WriteMEM()
 FI_IOMEM\tell_proc  = @FI_TellMEM()
 FI_IOMEM\seek_proc  = @FI_SeekMEM()
#FIC_noconvert=0
#FIC_8bitsWU=1
#FIC_8bitsNN=2
#FIC_16bits555=3
#FIC_16bits565=4
#FIC_24bits=5
#FIC_32bits=6
#FIC_bw=7
Procedure FI_SetClipboard(ImageNR,convert)
  result=0
  If convert=#FIC_noconvert
    ClearClipboard()
    dib=copyimage_(UseImage(imageNR),#IMAGE_BITMAP,0,0,#LR_COPYRETURNORG)
    SetClipboardData(#PB_ClipboardImage,dib)
    result=1
  Else
    dib=FreeImage_Bitmap_To_DIB(UseImage(imagenr))
    If dib>0
      Select convert
        Case #fic_8bitswu
          dibx=freeimage_convertTo24Bits(dib)
          dib2=FreeImage_ColorQuantize(dibx,#FIQ_WUQUANT)
        Case #fic_8bitsnn:
          dibx=freeimage_convertTo24Bits(dib)
          dib2=FreeImage_ColorQuantize(dibx,#FIQ_NNQUANT)
        Case #fic_16bits555: dib2=FreeImage_ConvertTo16Bits555(dib)
        Case #fic_16bits565: dib2=FreeImage_ConvertTo16Bits565(dib)
        Case #fic_24bits: dib2=FreeImage_ConvertTo24Bits(dib)
        Case #fic_32bits: dib2=FreeImage_ConvertTo32Bits(dib)
        Case #fic_bw: dib2=FreeImage_ConvertTo8Bits(dib)
      EndSelect
      If dibx>0 :freeimage_free(dibx):EndIf
      If dib2>0
        freeimage_free(dib)
        dib=dib2
      EndIf
      bitmap=FreeImage_DIB_To_Bitmap(dib)
      If bitmap>0
        ClearClipboard()
        SetClipboardData(#PB_ClipboardImage,bitmap)
        result=1
      EndIf
      FreeImage_Free(dib)
    EndIf
  EndIf
  ProcedureReturn result
EndProcedure
Procedure FI_GetClipboard(ImageNR)
  result=0
  ImageID=GetClipboardData(#PB_ClipboardImage)
  If imageid>0
    result=CreateImage(imageNR,FreeImage_GetBitmapWidth(ImageID),FreeImage_GetBitmapHeight(ImageID))
    StartDrawing(ImageOutput())
    DrawImage(ImageID,0,0)
    StopDrawing()
  EndIf
  ProcedureReturn result
EndProcedure
Procedure FI_SaveImage(ImageNr,File$,convert,Flags)
  result=0
  ImageFormat=freeimage_getFIFfromformat(GetExtensionPart(file$))
  If imageFormat<>#fif_unknown
    If FreeImage_FIFSupportsWriting(ImageFormat)
      If GetExtensionPart(file$)=""
        file$+"."+StringField(FreeImage_GetFIFExtensionList(ImageFormat),1,",")
      EndIf
      dib=FreeImage_bitmap_To_Dib(UseImage(ImageNr))
      If dib
        Select convert
          Case #fic_8bitswu
            If FreeImage_FIFSupportsExportBPP(ImageFormat,8)
              dibx=freeimage_convertTo24Bits(dib)
              dib2=FreeImage_ColorQuantize(dibx,#FIQ_WUQUANT)
            EndIf
          Case #fic_8bitsnn
            If FreeImage_FIFSupportsExportBPP(ImageFormat,8)
              dibx=freeimage_convertTo24Bits(dib)
              dib2=FreeImage_ColorQuantize(dibx,#FIQ_NNQUANT)
            EndIf
          Case #fic_16bits555
            If FreeImage_FIFSupportsExportBPP(ImageFormat,16)
              dib2=FreeImage_ConvertTo16Bits555(dib)
            EndIf
          Case #fic_16bits565
            If FreeImage_FIFSupportsExportBPP(ImageFormat,16)
              dib2=FreeImage_ConvertTo16Bits565(dib)
            EndIf
          Case #fic_24bits
            If FreeImage_FIFSupportsExportBPP(ImageFormat,24)
              dib2=FreeImage_ConvertTo24Bits(dib)
            EndIf
          Case #fic_32bits
            If FreeImage_FIFSupportsExportBPP(ImageFormat,32)
              dib2=FreeImage_ConvertTo32Bits(dib)
            EndIf
          Case #fic_bw
            If FreeImage_FIFSupportsExportBPP(ImageFormat,8)
              dib2=FreeImage_ConvertTo8Bits(dib)
            EndIf
        EndSelect
        If dibx :freeimage_free(dibx):EndIf
        If dib2
          freeimage_free(dib)
          dib=dib2
        EndIf
        result=FreeImage_Save(ImageFormat,DIB,File$,Flags)
        freeimage_free(dib)
      EndIf
    EndIf
  EndIf
  ProcedureReturn result
EndProcedure
Procedure FI_LoadImage(ImageNr,in$,Flags)
  result=0
  imageFormat=FreeImage_GetFileType(in$)
  If ImageFormat<>#FIF_Unknown
    dib=FreeImage_Load(ImageFormat,in$,Flags)
    If dib
      width=FreeImage_GetWidth(dib)
      height=FreeImage_GetHeight(dib)
      bitmap=FreeImage_DIB_To_Bitmap(dib)
      If bitmap
        result=CreateImage(imagenr,width,height)
        StartDrawing(ImageOutput())
        DrawImage(bitmap,0,0)
        StopDrawing()
        DeleteObject_(bitmap)
      EndIf
      FreeImage_free(dib)
    EndIf
  EndIf
  ProcedureReturn result
EndProcedure
Procedure FI_CatchImage(ImageNr,adr,Flags)
  fi_adrMEM=adr
  result=0
  imageFormat=FreeImage_GetFileTypeFromHandle(@FI_IOMEM.FreeImageIO,ADR)
  If ImageFormat<>#FIF_Unknown
    fi_adrMEM=adr
    dib=FreeImage_LoadFromHandle(ImageFormat,@FI_IOMEM.FreeImageIO,ADR,Flags)
    If dib
      width=FreeImage_GetWidth(dib)
      height=FreeImage_GetHeight(dib)
      bitmap=FreeImage_DIB_To_Bitmap(dib)
      If bitmap
        result=CreateImage(imagenr,width,height)
        StartDrawing(ImageOutput())
        DrawImage(bitmap,0,0)
        StopDrawing()
        DeleteObject_(bitmap)
      EndIf
      FreeImage_free(dib)
    EndIf
  EndIf
  ProcedureReturn result
EndProcedure 
; CursorPosition=83
; ExecutableFormat=Windows
; EOF